/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.animationdp.impl2;

import filenet.sim.animationdp.impl2.AnimationManager;
import filenet.sim.animationdp.impl2.IVWSIMEventReader;
import filenet.sim.animationdp.impl2.VWSIMMemEventBuffer;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;

class VWSIMMemEventReader
implements IVWSIMEventReader {
    private VWSIMMemEventBuffer m_buffer = null;
    private long m_nCurrentElement = 0L;
    protected static Logger logger = Logger.getLogger("filenet.sim.animationdp.retrieval");
    private String m_className = "VWSIMMemEventReader";
    private String m_scenarioId = null;

    public VWSIMMemEventReader(VWSIMMemEventBuffer buf) {
        this.m_buffer = buf;
        if (buf != null) {
            this.m_scenarioId = this.m_buffer.getScenarioId();
            this.m_className = this.m_className + ";";
            this.m_className = this.m_className + this.m_scenarioId;
        }
    }

    public AnimationManager getPrevious() throws VWException {
        if (this.m_nCurrentElement == 0L) {
            return null;
        }
        if (this.m_nCurrentElement > 0L) {
            --this.m_nCurrentElement;
        }
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnimationManager get() throws VWException {
        String m_method = "get";
        if (this.m_nCurrentElement == 0L) {
            logger.info(this.m_className, m_method, "Starting..");
        }
        try {
            AnimationManager res;
            if (!this.hasNext()) {
                if (this.m_buffer.getStatus() == 65535) {
                    throw new VWException("filenet.sim.animationdp.eventbuf.retrievalError..", "Retrieval error, {0}", this.m_buffer.getStatusMessage());
                }
                if (this.m_buffer.finished()) {
                    return null;
                }
                VWSIMMemEventBuffer vWSIMMemEventBuffer = this.m_buffer;
                synchronized (vWSIMMemEventBuffer) {
                    for (long time = 0L; !this.hasNext() && time < 900000L; time += 15000L) {
                        this.m_buffer.wait(15000L);
                    }
                    if (!this.hasNext()) {
                        throw new VWException("filenet.sim.animationdp.eventbuf.retrievalError.", "Retrieval error, {0}", this.m_buffer.getStatusMessage());
                    }
                }
            }
            if ((res = (AnimationManager)this.m_buffer.getList().get((int)this.m_nCurrentElement)) == null && !this.m_buffer.finished()) {
                VWSIMMemEventBuffer vWSIMMemEventBuffer = this.m_buffer;
                synchronized (vWSIMMemEventBuffer) {
                    this.m_buffer.wait();
                    if (!this.m_buffer.finished()) {
                        res = (AnimationManager)this.m_buffer.getList().get((int)this.m_nCurrentElement);
                    }
                }
            }
            if (res == null) {
                if (this.m_buffer.getStatus() == 4) {
                    throw new VWException("filenet.sim.animationdp.eventbuf.retrievalError..", "Retrieval error, {0}", this.m_buffer.getStatusMessage());
                }
                return null;
            }
            ++this.m_nCurrentElement;
            return res;
        }
        catch (Exception e) {
            logger.throwing(this.m_className, m_method, e);
            throw new VWException(e);
        }
    }

    public boolean hasNext() {
        try {
            boolean m_finished = this.m_buffer.finished();
            long size = this.m_buffer.getSize();
            return this.m_nCurrentElement < size || this.m_nCurrentElement == size && !m_finished;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void releaseResources() {
        this.reset();
        this.m_buffer = null;
    }

    public void reset() {
        this.m_nCurrentElement = 0L;
    }

    protected void finalize() {
        this.releaseResources();
    }
}

